//-----
//
// HFI - Commandlineversion - WATCOM C/C++ 11.0
// 04.1998 by bingen@gmx.de - use m.bat to compile
//    upd 1.05 - 06.1998 - sorting mainindex, if no subs no mainindexlink
//
//-----

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <string.h>
#include <dos.h>
#include <direct.h>

#define TRUE   1
#define FALSE  0
#define MAXWERT      2000   //soviele files sollten wohl reichen, oder?
#define MAX_PATH     500    //laengste rekursion
#define MAX_FNLEN    255    //laengster filename
#define MAX_DIRS     500    
#define PROGVERSION  "1.05" //na was wohl?
#define COPYR        "(c)1998 by -BiNGEN- (bingen@gmx.de)" 
#define COMMENTSTR   "<!--generated by HFI "PROGVERSION"/html-file-indexer\n    "COPYR" -->\n"
#define METASTR      "<meta name=\"generator\" content=\"HFI "PROGVERSION"/"OS_VERSION"\">\n"
#define VERSIONSTR   "HFI "PROGVERSION"/"OS_VERSION

#ifdef WINNT
#define OS_VERSION   "winnt32"
#endif
#ifdef DOS4G
#define OS_VERSION   "dos4gw"
#endif

char  outframe[20];  
char  mainframe[20];  
char  colorstr[100];  

char fnames[MAXWERT][MAX_FNLEN];
int  anz_fnames;
char spec[15][15];
int  anz_spec;
char dirnames[MAX_DIRS][MAX_PATH];
int  anz_dirs;
int  home_len;
int  subs;


/*****************************************************************************/
void makeframe(char *path ,char *filename)
{
   FILE  *stream;
   char  akt_file[MAX_PATH];

   sprintf(akt_file,"%s\\%s", path, mainframe);

   if((stream=fopen(akt_file,"w"))!=NULL)
      {
      fputs("<html><head>\n", stream);
      fputs(METASTR, stream);
      fputs(COMMENTSTR, stream);
      fputs("<title>Index of ", stream);
      fputs(&path[home_len], stream);
      fputs("</title></head>\n", stream);
      fputs("<frameset cols=\"20%,*\" border=\"3\">\n", stream);
      fputs("<frame src=\"", stream);
      fputs(outframe, stream);
      fputs("\" name=\"left\">\n", stream);
      fputs("<frame src=\"", stream);
      fputs(filename, stream);
      fputs("\" name=\"right\">\n</frameset>\n</html>", stream);
      fclose(stream);
      }
   else
      printf("..can't open %s\n", akt_file);

}

/*****************************************************************************/
long buildarray(char *path)
{
   struct _finddata_t   fileinfo;
   long                 handle, bytes;
   int                  rc;
   char                 tausch[MAX_FNLEN];
   char                 akt_file[MAX_PATH];
   register int         i, j;

   anz_fnames=0;
   bytes=0L;

   for(i=0;i<anz_spec;i++)
      {
      sprintf(akt_file,"%s\\%s", path, spec[i]);

      handle=_findfirst(akt_file, &fileinfo);
      rc=handle;
      while(rc!=-1)
         {
         if(anz_fnames>MAXWERT-1)
            {
            printf("*.file-overflow! (more than %d files)\n", MAXWERT);
            break;
            }
         else
            {
            if (strcmp(fileinfo.name,"..")!=0
            && strcmp(fileinfo.name,".")!=0
            && !(fileinfo.attrib&_A_SUBDIR))
               {
               strcpy(fnames[anz_fnames++], fileinfo.name);
               bytes+=fileinfo.size;
               }
            }
   
         rc=_findnext(handle, &fileinfo);
         }
       _findclose(handle);
      }

   // fuer die paar strings reicht ein bubblesort
   for(i=0;i<anz_fnames-1;i++)
      {
       for(j=i+1;j<anz_fnames;j++)
         {
         if (strcmp(fnames[i],fnames[j])>0)
            {
            strcpy(tausch, fnames[i]);
            strcpy(fnames[i], fnames[j]);
            strcpy(fnames[j], tausch);
            }
         }
      }

   return(bytes);

}
/*****************************************************************************/
void usage(void)
{
   printf(".compiled with watcom c/c++ 11.0. edited with zeus32 2.60.\n");
   printf(" (the dos4gw-version needs dos4gw.exe, the winnt-version windows95/nt)\n\n");
   printf(".status: freeware. use as often as you want.\n");
   printf(".update: if any... check out http://www.lastresort.net.\n\n");
   printf(".description:\nthis cute, little program builds a html-index of the files in a directory.\n");
   printf("it uses frames. on the left are the filenames, right the file itself.\n\n");
   printf(".main purpose:\ncreating indexes for cd-rom's with jpg's or other media.\n\n");
   //printf("[more]\n\n"); getch();
   printf(".arguments:\n -?, /? - this help.\n");
   printf(" /s     - include all subdirs.\n");
   printf(" /t[x]  - filetypes (i=jpg,gif (default) / t=txt,doc / s=wav,mid,mp3).\n");
   printf("                    (h=htm,html / m=avi,mpg,mov / *=all filetypes).\n\n");
   printf(".example: hfi /th /tt (make index with all htm/txt/doc files).\n");
   exit(0);
}

/*****************************************************************************/
char *makedots(char *in)
{
   register int   i;
   char out[MAX_FNLEN]="";

   for(i=0;i<strlen(in)+1;i++)
      {
      if (in[i]=='\\')
         strcat(out, "../");
      }
   
   strcpy(in, out);
   return(in);
}

/*****************************************************************************/
void makepage(char *path)
{
   FILE  *stream;
   char  outstr[MAX_PATH];
   char  akt_file[MAX_PATH];
   char  dotstr[MAX_FNLEN];
   int   i;
   long  bytes;

   if(bytes=buildarray(path))
      {

      sprintf(akt_file,"%s\\%s", path, outframe);

      if((stream=fopen(akt_file,"w"))!=NULL)
         {
         
         if(anz_dirs>MAX_DIRS-1)
            printf("*.dir-overflow! (more than %d dirs)\n", MAX_DIRS);
         else
            strcpy(dirnames[anz_dirs++], path);

         // geht zwar, aber nicht unbedingt sinnvoll
         //strlen(&path[home_len])==0?strcpy(outstr,"\\"): strcpy(outstr,&path[home_len]);

         makeframe(path, fnames[0]);
         printf("..processing %s (%i bytes)\n", path, bytes);
         fputs("<html><head>\n", stream);
         fputs(METASTR, stream);
         fputs("<base target=\"right\">\n", stream);
         fputs("<title>Index of ", stream);
         fputs(&path[home_len], stream);
         fputs("</title></head>\n<body ", stream);
         fputs(colorstr, stream);
         fputs(">\n<font face=\"Arial, Helvetica\" size=-1><b>Index&nbsp;of ", stream);
         fputs(&path[home_len], stream);
         fputs("</b><hr>\n", stream);

         // nur wenn mit subs
         if(subs)
            {
            strcpy(dotstr, &path[home_len]);
            sprintf(outstr, "<a href=\"%sindex.htm\" target=_parent><b>MainIndex</b></a><hr>\n", makedots(dotstr));
            fputs(outstr, stream);
            }

         for(i=0;i<anz_fnames;i++)
            {
            sprintf(outstr, "<a href=\"%s\">%s</a><br>\n", fnames[i], fnames[i]);
            fputs(outstr, stream);
            }

         fputs("<hr><a href=\"#top\" target=_self><b>Top of Page</b></a>\n", stream);
         fputs("</font></body></html>\n", stream);
         fclose(stream);
         }
      else
         printf("..can't open %s\n", akt_file);

      }
   else
      printf("..no matching files in %s\n", path);

}
/*****************************************************************************/
void scandirs(char *path)
{
   struct find_t  fileinfo;
   char           akt_pfad[MAX_PATH];

   strcpy(akt_pfad, path);
   strcat(akt_pfad, "\\*.*");

   if (_dos_findfirst(akt_pfad, _A_SUBDIR ,&fileinfo)==0)
   {
      do
      {
         if (strcmp(fileinfo.name,"..")!=0)
         {
            if (strlen(path)+strlen(fileinfo.name)>=MAX_PATH)
            {
              printf("..path: %s sub: %s\n..recursion too deep!\n", akt_pfad, fileinfo.name);
            }
            else
              {
              if(strcmp(fileinfo.name,".")==0)
               {
               // darum gehts eigentlich =;-)
               makepage(path);
               }
              else
               {
               // kleine rekursion :-)
               strcpy(akt_pfad, path);
               strcat(akt_pfad, "\\");
               strcat(akt_pfad, fileinfo.name);
               scandirs(akt_pfad);
               }
            }
         }
      }
      while ((_dos_findnext(&fileinfo)==0));
   }

}
/*****************************************************************************/
char *tweakdirname(char *in, char *path)
{
   register int   i, k=strlen(in)-strlen(path);

   for(i=strlen(path)+1;i<strlen(in)+1;i++)
      {
      if (in[i]=='\\')
         in[i-(strlen(path)+1)]='/';
      else
         in[i-(strlen(path)+1)]=in[i];
      }
   in[k]='\0';
   if(strlen(in)==0) strcpy(in, ".");

   return(in);
}

/*****************************************************************************/
void buildidx(char *path)
{
   register int   i,j;
   char  outstr[MAX_PATH];
   char  outfile[MAX_PATH];
   char  tausch[MAX_FNLEN];
   FILE  *stream;

   if(anz_dirs)
      {
      
      // noch'n bubblesort
      for(i=0;i<anz_dirs-1;i++)
         {
          for(j=i+1;j<anz_dirs;j++)
            {
            if (strcmp(dirnames[i],dirnames[j])>0)
               {
               strcpy(tausch, dirnames[i]);
               strcpy(dirnames[i], dirnames[j]);
               strcpy(dirnames[j], tausch);
               }
            }
         }
      
      strcpy(outfile, path);
      strcat(outfile, "\\index.htm");
      if((stream=fopen(outfile,"w"))!=NULL)
         {
         printf("..building mainindex %s\n", outfile);
         fputs("<html><head>\n", stream);
         fputs(METASTR, stream);
         fputs(COMMENTSTR, stream);
         fputs("<title>Index created by ", stream);
         fputs(VERSIONSTR, stream);
         fputs("</title></head>\n<body ", stream);
         fputs(colorstr, stream);
         //fputs(" onload=\"self.status='&#169; 1998 by bingen@gmx.de'\">", stream);
         fputs(">\n<font face=\"Arial, Helvetica\" size=-1><h2><b>Index created by ", stream);
         fputs(VERSIONSTR, stream);
         fputs("</h2></b><hr>\n", stream);

         for(i=0;i<anz_dirs;i++)
            {
            tweakdirname(dirnames[i], path);
            sprintf(outstr, "<a href=\"%s/%s\">%s</a><br>\n", dirnames[i], mainframe, dirnames[i]);
            fputs(outstr, stream);
            }

         fputs("<hr></font></body></html>\n", stream);
         fclose(stream);
         }
      else
         printf("..can't open %s\n", outfile);
      }

}

/*****************************************************************************/
void main(int argc, char *argv[])
{
   char           homedir[MAX_FNLEN];
   register int   i;

   anz_spec=anz_dirs=0;
   subs=FALSE;

   printf("\nHFI "PROGVERSION" - html-file-indexer ("OS_VERSION")\n");
	printf(COPYR" * use /? for help.\n\n");

   // gibts argumente dafuer? ;-)
   for (i=1;i<argc;i++)
     {
     if (argv[i][0]=='/' || argv[i][0]=='-')
        {
        if(argv[i][1]=='?') usage();
        
        if(argv[i][1]=='s' || argv[i][1]=='S') subs=TRUE;

        if(argv[i][1]=='t' || argv[i][1]=='T')
         {
         if(argv[i][2]=='i' || argv[i][2]=='I')
            {
            strcpy(spec[anz_spec++], "*.jpg");
            strcpy(spec[anz_spec++], "*.gif");
            }
         if(argv[i][2]=='h' || argv[i][2]=='H')
            {
            strcpy(spec[anz_spec++], "*.htm");
            strcpy(spec[anz_spec++], "*.html");
            }
         if(argv[i][2]=='t' || argv[i][2]=='T')
            {
            strcpy(spec[anz_spec++], "*.doc");
            strcpy(spec[anz_spec++], "*.txt");
            }
         if(argv[i][2]=='m' || argv[i][2]=='M')
            {
            strcpy(spec[anz_spec++], "*.avi");
            strcpy(spec[anz_spec++], "*.mpg");
            strcpy(spec[anz_spec++], "*.mov");
            }
         if(argv[i][2]=='s' || argv[i][2]=='S')
            {
            strcpy(spec[anz_spec++], "*.wav");
            strcpy(spec[anz_spec++], "*.mid");
            strcpy(spec[anz_spec++], "*.mp3");
            }
         if(argv[i][2]=='*')
            {
            strcpy(spec[0], "*.*");
            anz_spec=1;
            }
         }
        }
     else
        {
        printf("Unknown option \"%s\". try /? for help.\n", argv[i]);
        exit(-1);
        }
     }

   // die filenamen per argument? hab ich grad kein bock...
   strcpy(outframe,"_idx.htm");
   strcpy(mainframe,"idx.htm");
   strcpy(colorstr,"bgcolor=\"#cccccc\" text=\"#000033\" link=\"#000033\" vlink=\"#666666\" alink=\"#ff0000\"");

   strcpy(homedir,getcwd( NULL ,0));
   if(strlen(homedir)==3) homedir[strlen(homedir)-1]='\0';
   home_len=strlen(homedir);

   //defaultwerte falls nichts gesetzt
   if(anz_spec<1)
      {
      strcpy(spec[anz_spec++], "*.jpg");
      strcpy(spec[anz_spec++], "*.gif");
      }
   printf("..indexing: ");
   for(i=0;i<anz_spec;i++)
      printf("%s ",spec[i]);

   if(subs)
      {
      printf("\n..starting at %s incl. subdirs\n", homedir);
      scandirs(homedir);
      buildidx(homedir);
      }
   else
      {
      printf("\n");
      makepage(homedir);
      }

   printf("..done.\n\nthnx for using HFI "PROGVERSION", bye.\n");

}
/*****************************************************************************/

